import { View, Text, FlatList, TouchableOpacity } from "react-native";
import { useEffect, useState } from "react";
import styles from "./ReviewsStyle";
import { useNavigation } from "@react-navigation/native";
import ItemSeparator from "../../../../../screens/Utilities/ItemSeparator/ItemSeparator";
import ProductReviewsItem from "../../../ProductReviewsItem/ProductReviewsItem";
import useLangTranslation from "../../../../../hooks/useLangTranslation";
import gapStyle from "../../../../../screens/Utilities/CommonStyles/gap.style";
import RightIcon from "../../../../../assets/svgs/product details/rightIcon.svg"
import CustomSVG from "../../../CustomSVG/CustomSVG";

const Reviews = ({ vendorProductReviews }) => {
	const navigation = useNavigation();
	const [reviewsData, setReviewsData] = useState([]);

	useEffect(() => {
		setReviewsData(vendorProductReviews.slice(0, 2));
	},[vendorProductReviews])

	return (
		<View style={styles.container}>
			<FlatList
				data={reviewsData}
				renderItem={({ item }) => <ProductReviewsItem item={item} />}
				keyExtractor={(item) => "c" + item.id.toString()}
				ItemSeparatorComponent={() => <ItemSeparator />}
				showsVerticalScrollIndicator={false}
				ListHeaderComponent={ListHeaderComponent}
				ListFooterComponent={() => (
					<ListFooterComponent navigation={navigation} />
				)}
				ListFooterComponentStyle={styles.listFooter}
			/>
		</View>
	);
};

export default Reviews;

const ListHeaderComponent = () => {
	const { trans } = useLangTranslation();
	return <Text style={[styles.headerText, gapStyle.mt20]}>{trans("Product Reviews")}</Text>;
};

const ListFooterComponent = ({ navigation }) => {
	const { trans } = useLangTranslation();
	return (
		<TouchableOpacity
			onPress={() => navigation.navigate("Vendor Reviews")}
			style={styles.seeAllButtonText}
		>
			<Text style={styles.seeAllButtonText}>
				{trans("See All")}
			</Text>
			<CustomSVG svgIcon={RightIcon} isRtl={1} fill={"#898989"} />
		</TouchableOpacity>
	);
};
